
*category of reference: frequency= low, neighbourhood= none, duden= no, cue=s no*

LOGISTIC REGRESSION VARIABLES Lang_Decision
  /METHOD=ENTER Frequency Neighbourhood Duden Cues_new 
  /CONTRAST (Frequency)=Indicator(1)
  /CONTRAST (Neighbourhood)=Indicator(1)
  /CONTRAST (Duden)=Indicator
  /CONTRAST (Cues_new)=Indicator
  /PRINT=GOODFIT SUMMARY CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).


*Filter to select subset of group 2, with residence in German and evaluating words of English origin*

USE ALL.
COMPUTE filter_$=((Case  =  623 | Case  =  625 | Case  =  628 | Case  =  631 | Case  =  639 | Case  
    =  642 | Case  =  657 | Case  =  660 | Case  =  663 | Case  =  665 | Case  =  668 | Case  =  678 | 
    Case  =  696 | Case  =  704 | Case  =  710 | Case  =  716 | Case  =  727 | Case  =  736 | Case  =  
    738 | Case  =  741 | Case  =  752 | Case  =  759 | Case  =  771 | Case  =  776 | Case  =  793 | 
    Case  =  800 | Case  =  801 | Case  =  819 | Case  =  823 | Case  =  827 | Case  =  835 | Case  =  
    845 | Case  =  855 | Case  =  858 | Case  =  862 | Case  =  874 | Case  =  885 | Case  =  888 | 
    Case  =  907 | Case  =  908 | Case  =  920 | Case  =  939 | Case  =  956 | Case  =  967 | Case  =  
    977 | Case  =  989 | Case  =  991 | Case  =  997 | Case  =  1000 | Case  =  1010 | Case  =  1018 ) 
    & Residence = 1 & Wortfunktion = 2).
VARIABLE LABELS filter_$ '(Case  =  623 | Case  =  625 | Case  =  628 | Case  =  631 | Case  =  '+
    '639 | Case  =  642 | Case  =  657 | Case  =  660 | Case  =  663 | Case  =  665 | Case  =  668 '+
    '| Case  =  678 | Case  =  696 | Case  =  704 | Case  =  710 | Case  =  716 | ... (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.


*Filter for group1 to select cases with residence in Germany evaluating words of German origin*


USE ALL.
COMPUTE filter_$=(Residence = 1 & Wortfunktion = 1).
VARIABLE LABELS filter_$ 'Residence = 1 & Wortfunktion = 1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*Regression model with neighbourhood and cues*

LOGISTIC REGRESSION VARIABLES Lang_Decision
  /METHOD=ENTER Neighbourhood Cues_new 
  /CONTRAST (Neighbourhood)=Indicator(1)
  /CONTRAST (Cues_new)=Indicator(1)
  /PRINT=GOODFIT SUMMARY CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).


*Filter to select subset of group 2, with residence in German and evaluating words of German origin*


USE ALL.
COMPUTE filter_$=((Case  =  623 | Case  =  625 | Case  =  628 | Case  =  631 | Case  =  639 | Case  
    =  642 | Case  =  657 | Case  =  660 | Case  =  663 | Case  =  665 | Case  =  668 | Case  =  678 | 
    Case  =  696 | Case  =  704 | Case  =  710 | Case  =  716 | Case  =  727 | Case  =  736 | Case  =  
    738 | Case  =  741 | Case  =  752 | Case  =  759 | Case  =  771 | Case  =  776 | Case  =  793 | 
    Case  =  800 | Case  =  801 | Case  =  819 | Case  =  823 | Case  =  827 | Case  =  835 | Case  =  
    845 | Case  =  855 | Case  =  858 | Case  =  862 | Case  =  874 | Case  =  885 | Case  =  888 | 
    Case  =  907 | Case  =  908 | Case  =  920 | Case  =  939 | Case  =  956 | Case  =  967 | Case  =  
    977 | Case  =  989 | Case  =  991 | Case  =  997 | Case  =  1000 | Case  =  1010 | Case  =  1018 ) 
    & Residence = 1 & Wortfunktion = 1).
VARIABLE LABELS filter_$ '(Case  =  623 | Case  =  625 | Case  =  628 | Case  =  631 | Case  =  '+
    '639 | Case  =  642 | Case  =  657 | Case  =  660 | Case  =  663 | Case  =  665 | Case  =  668 '+
    '| Case  =  678 | Case  =  696 | Case  =  704 | Case  =  710 | Case  =  716 | ... (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.


LOGISTIC REGRESSION VARIABLES Lang_Decision
  /METHOD=ENTER Neighbourhood Cues_new 
  /CONTRAST (Neighbourhood)=Indicator(1)
  /CONTRAST (Cues_new)=Indicator(1)
  /PRINT=GOODFIT SUMMARY CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).


*Teste Einfluss der persnlichen Faktoren auf Lang Decision, gesamter Datensatz*

USE ALL.
COMPUTE filter_$=(Residence = 1 & Wortfunktion = 2).
VARIABLE LABELS filter_$ 'Residence = 1 & Wortfunktion = 2 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.


LOGISTIC REGRESSION VARIABLES Lang_Decision
  /METHOD=ENTER MT_English_new MT_German_new Ling_trained Age_Cat LC_readwrite_new 
  /CONTRAST (Ling_trained)=Indicator(1)
  /CONTRAST (MT_English_new)=Indicator(1)
  /CONTRAST (MT_German_new)=Indicator
  /PRINT=GOODFIT SUMMARY CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).



* Analyse all predictors of language decisions*

LOGISTIC REGRESSION VARIABLES Lang_Decision
  /METHOD=ENTER MT_English_new MT_German_new Ling_trained Age_Cat LC_readwrite_new Duden Cues_new 
    Frequency 
  /CONTRAST (Ling_trained)=Indicator(1)
  /CONTRAST (MT_English_new)=Indicator(1)
  /CONTRAST (MT_German_new)=Indicator
  /CONTRAST (Duden)=Indicator(1)
  /CONTRAST (Cues_new)=Indicator(1)
  /CONTRAST (Frequency)=Indicator(1)
  /CLASSPLOT
  /PRINT=GOODFIT SUMMARY CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).

*Filter for residence in Germany, mother tongue is German, and no linguistic training*

USE ALL.
COMPUTE filter_$=(Residence = 1 &  MT_German_new = 1 & Ling_trained = 0).
VARIABLE LABELS filter_$ 'Residence = 1 &  MT_German_new = 1 & Ling_trained = 0 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

LOGISTIC REGRESSION VARIABLES Lang_Decision
  /METHOD=ENTER Duden Cues_new Age_Cat LC_readwrite_new Frequency 
  /CONTRAST (Duden)=Indicator(1)
  /CONTRAST (Cues_new)=Indicator(1)
  /CONTRAST (Frequency)=Indicator(1)
  /PRINT=GOODFIT SUMMARY CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).


*Analyse English stimuli evaluated by German native speakers without ling training*


USE ALL.
COMPUTE filter_$=(Residence = 1 &  MT_German_new = 1 & Ling_trained = 0 & Wortfunktion = 2 & 
    MT_English = 0).
VARIABLE LABELS filter_$ 'Residence = 1 &  MT_German_new = 1 & Ling_trained = 0 & Wortfunktion = '+
    '2 & MT_English = 0 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

LOGISTIC REGRESSION VARIABLES Lang_Decision
  /METHOD=ENTER Duden Cues_new Age_Cat LC_readwrite_new Frequency 
  /CONTRAST (Duden)=Indicator(1)
  /CONTRAST (Cues_new)=Indicator(1)
  /CONTRAST (Frequency)=Indicator(1)
  /CLASSPLOT
  /PRINT=GOODFIT SUMMARY CI(95)
  /CRITERIA=PIN(0.05) POUT(0.10) ITERATE(20) CUT(0.5).
